<?php
session_start();
include "../koneksi.php";

if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'kasir'){
    header("Location: ../login.php");
    exit;
}

if(!isset($_GET['id'])){
    header("Location: transaksi.php");
    exit;
}

$id_transaksi = intval($_GET['id']);

// Ambil data transaksi
$query_transaksi = mysqli_query($koneksi,"SELECT * FROM transaksi WHERE id_transaksi='$id_transaksi'");
if(!$query_transaksi){
    die("Query transaksi gagal: ".mysqli_error($koneksi));
}

$transaksi = mysqli_fetch_assoc($query_transaksi);
if(!$transaksi){
    die("Transaksi dengan ID $id_transaksi tidak ditemukan.");
}

// Ambil detail transaksi
$query_detail = mysqli_query($koneksi,"SELECT * FROM transaksi_detail WHERE id_transaksi='$id_transaksi'");
if(!$query_detail){
    die("Query detail transaksi gagal: ".mysqli_error($koneksi));
}
$detail = $query_detail;

?>

<!DOCTYPE html>
<html>
<head>
    <title>Transaksi Berhasil - Elino.Computer</title>
    <style>
        body{font-family:Arial;background:#f4f6f8;padding:20px;}
        .container{max-width:700px;margin:50px auto;background:#fff;padding:25px;border-radius:8px;box-shadow:0 0 12px rgba(0,0,0,0.1);}
        h2{text-align:center;color:#28a745;margin-bottom:5px;}
        p.tanggal{text-align:center;color:#555;font-size:14px;margin-top:0;margin-bottom:20px;}
        table{width:100%;border-collapse:collapse;margin-top:10px;}
        th,td{border:1px solid #ccc;padding:10px;text-align:center;}
        th{background:#28a745;color:white;}
        .total{font-weight:bold;background:#e9f5ee;}
        .back{display:inline-block;margin-top:20px;text-decoration:none;color:#007bff;font-weight:bold;}
        .back:hover{text-decoration:underline;}
    </style>
</head>
<body>
<div class="container">
    <h2>Transaksi Berhasil</h2>
    <p class="tanggal">Tanggal: <?= date('d-m-Y H:i:s', strtotime($transaksi['tanggal'])) ?></p>

    <table>
        <tr>
            <th>Produk</th>
            <th>Harga</th>
            <th>Jumlah</th>
            <th>Subtotal</th>
        </tr>
        <?php while($d=mysqli_fetch_assoc($detail)){ ?>
        <tr>
            <td><?= htmlspecialchars($d['nama_produk']) ?></td>
            <td>Rp <?= number_format($d['harga'],0,',','.') ?></td>
            <td><?= $d['qty'] ?></td>
            <td>Rp <?= number_format($d['subtotal'],0,',','.') ?></td>
        </tr>
        <?php } ?>
        <tr>
            <td colspan="3" class="total">Total</td>
            <td>Rp <?= number_format($transaksi['total_harga'],0,',','.') ?></td>
        </tr>
        <tr>
            <td colspan="3" class="total">Bayar</td>
            <td>Rp <?= number_format($transaksi['uang_bayar'],0,',','.') ?></td>
        </tr>
        <tr>
            <td colspan="3" class="total">Kembalian</td>
            <td>Rp <?= number_format($transaksi['kembalian'],0,',','.') ?></td>
        </tr>
    </table>

    <a href="transaksi.php" class="back">← Transaksi Baru</a>
    <a href="dashboard_kasir.php" class="back" style="margin-left:20px;">← Dashboard</a>
</div>
</body>
</html>
