<?php
session_start();
include "../koneksi.php";

if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'kasir'){
    header("Location: ../login.php");
    exit;
}

// Ambil username kasir dari session
$kasir_username = $_SESSION['username'];

// Ambil data user lengkap (termasuk nama)
$q_user = mysqli_query($koneksi,"SELECT * FROM users WHERE username='$kasir_username' LIMIT 1");
$u = mysqli_fetch_assoc($q_user);
$kasir_nama = $u['nama'] ?? $kasir_username; // fallback ke username jika nama kosong

// Total produk
$q_produk = mysqli_query($koneksi,"SELECT COUNT(*) AS total FROM produk");
$row = mysqli_fetch_assoc($q_produk);
$total_produk = $row['total'] ?? 0;

// Bulan ini
$bulan_ini = date('Y-m');

// Transaksi bulan ini milik kasir
$q_transaksi = mysqli_query($koneksi,"
    SELECT COUNT(*) AS total, COALESCE(SUM(total_harga),0) AS pendapatan 
    FROM transaksi 
    WHERE kasir='$kasir_username' AND DATE_FORMAT(tanggal,'%Y-%m')='$bulan_ini'
");
$row = mysqli_fetch_assoc($q_transaksi);
$total_transaksi = $row['total'] ?? 0;
$total_pendapatan = $row['pendapatan'] ?? 0;

// 5 transaksi terakhir milik kasir
$q_histori = mysqli_query($koneksi,"SELECT id_transaksi, kasir, total_harga, bayar, kembalian, tanggal 
    FROM transaksi 
    WHERE kasir='$kasir_username' 
    ORDER BY id_transaksi DESC 
    LIMIT 5");
?>

<!DOCTYPE html>
<html>
<head>
<title>Dashboard Kasir - Elino.Computer</title>
<style>
body, html{margin:0;padding:0;font-family:'Segoe UI',sans-serif;background:#e2e8f0;}
.header{
    background:#0f172a;
    color:#fff;
    padding:25px 30px;
    text-align:center;
    box-shadow:0 4px 12px rgba(0,0,0,0.2);
    font-size:22px;
}
.header span{font-weight:bold; color:#38bdf8;}

/* Sidebar */
.sidebar{
    width:220px;
    background:#1e293b;
    color:#fff;
    position:fixed;
    top:0; left:0;
    height:100%;
    padding-top:90px;
    transition:0.3s;
}
.sidebar h3{text-align:center;margin-bottom:20px;font-size:18px;color:#f3f4f6;}
.sidebar a{
    display:flex;
    align-items:center;
    color:#e5e7eb;
    padding:12px 20px;
    text-decoration:none;
    transition:0.3s;
}
.sidebar a:hover{background:#2563eb;color:#fff;border-radius:8px;}
.sidebar a i{margin-right:10px;}

/* Content */
.content{margin-left:220px;padding:30px;}

/* Cards */
.cards{display:flex;gap:20px;flex-wrap:wrap;margin-top:20px;}
.card{
    background:#fff;
    flex:1 1 250px;
    padding:20px;
    border-radius:12px;
    box-shadow:0 6px 16px rgba(0,0,0,0.15);
    display:flex;
    align-items:center;
    gap:15px;
}
.card i{
    font-size:40px;
    color:#38bdf8;
}
.card h4{margin:0;color:#1e293b;}
.card p{font-size:22px;font-weight:bold;margin:0;color:#0f172a;}

/* Table */
table{
    width:100%;
    border-collapse:collapse;
    margin-top:20px;
    background:#fff;
    border-radius:12px;
    overflow:hidden;
    box-shadow:0 4px 12px rgba(0,0,0,0.1);
}
th,td{padding:12px;text-align:center;border-bottom:1px solid #ddd;}
th{background:#0f172a;color:white;}
tr:hover{background:#f1f5f9;}
.btn-detail{
    padding:5px 10px;
    background:#22c55e;
    color:white;
    border:none;
    border-radius:6px;
    cursor:pointer;
}
.btn-detail:hover{background:#16a34a;}
.back{
    display:inline-block;
    margin-top:20px;
    text-decoration:none;
    color:#2563eb;
    font-weight:bold;
}
.back:hover{text-decoration:underline;}

/* Modal */
.modal{display:none;position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);justify-content:center;align-items:center;}
.modal-content{background:#fff;padding:20px;border-radius:12px;max-width:600px;width:90%;position:relative;}
.close{position:absolute;top:10px;right:15px;font-size:20px;cursor:pointer;}
.modal-content table{width:100%;border-collapse:collapse;margin-top:10px;}
.modal-content th, .modal-content td{border:1px solid #ddd;padding:8px;text-align:center;}
.modal-content th{background:#0f172a;color:white;}
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>

<div class="header">🖥️ <span>Elino.Computer</span> - Dashboard Kasir</div>

<div class="sidebar">
<h3>Menu Kasir</h3>
<a href="dashboard_kasir.php"><i class="fa fa-tachometer-alt"></i> Dashboard</a>
<a href="transaksi.php"><i class="fa fa-cart-plus"></i> Transaksi Baru</a>
<a href="lihat_produk.php"><i class="fa fa-box"></i> Lihat Produk</a>
<a href="../logout.php"><i class="fa fa-right-from-bracket"></i> Logout</a>
</div>

<div class="content">
<h3>Selamat datang, <?= htmlspecialchars($kasir_nama); ?>!</h3>
<p>Anda login sebagai <strong>Kasir</strong></p>

<div class="cards">
<div class="card"><i class="fa fa-box"></i><div><h4>Total Produk</h4><p><?= $total_produk ?></p></div></div>
<div class="card"><i class="fa fa-receipt"></i><div><h4>Transaksi Bulan Ini</h4><p><?= $total_transaksi ?></p></div></div>
<div class="card"><i class="fa fa-money-bill-wave"></i><div><h4>Total Pendapatan Bulan Ini</h4><p>Rp <?= number_format($total_pendapatan,0,',','.') ?></p></div></div>
</div>

<h3>5 Transaksi Terakhir</h3>
<table>
<tr>
<th>ID</th><th>Kasir</th><th>Total</th><th>Bayar</th><th>Kembalian</th><th>Tanggal</th><th>Detail</th>
</tr>
<?php while($t=mysqli_fetch_assoc($q_histori)){ ?>
<tr>
<td><?= $t['id_transaksi'] ?></td>
<td><?= htmlspecialchars($t['kasir']) ?></td>
<td>Rp <?= number_format($t['total_harga'] ?? 0,0,',','.') ?></td>
<td>Rp <?= number_format($t['bayar'] ?? 0,0,',','.') ?></td>
<td>Rp <?= number_format($t['kembalian'] ?? 0,0,',','.') ?></td>
<td><?= date('d-m-Y', strtotime($t['tanggal'])) ?></td>
<td><button class="btn-detail" onclick="lihatStruk(<?= $t['id_transaksi'] ?>)">Detail</button></td>
</tr>
<?php } ?>
</table>

<a href="../logout.php" class="back">← Logout</a>
</div>

<div id="modalStruk" class="modal">
<div class="modal-content">
<span class="close" onclick="document.getElementById('modalStruk').style.display='none'">&times;</span>
<div id="kontenStruk">Loading...</div>
<button onclick="window.print()" style="margin-top:10px;padding:5px 10px;background:#22c55e;color:white;border:none;border-radius:6px;cursor:pointer;">🖨️ Cetak Struk</button>
</div>
</div>

<script>
function lihatStruk(id_transaksi){
    document.getElementById('modalStruk').style.display='flex';
    document.getElementById('kontenStruk').innerHTML = 'Loading...';
    fetch('struk_ajax.php?id_transaksi='+id_transaksi)
    .then(res=>res.text())
    .then(html=>document.getElementById('kontenStruk').innerHTML=html);
}
// Update last activity setiap 1 menit agar tetap online
setInterval(() => {
    fetch('../heartbeat.php');
}, 60000);
</script>

</body>
</html>

