<?php
session_start();
include "../koneksi.php";

if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'admin'){
    header("Location: ../login.php");
    exit;
}

// Filter bulan, default bulan ini
$bulan = $_GET['bulan'] ?? date('Y-m');

$q_transaksi = mysqli_query($koneksi,"SELECT * FROM transaksi 
    WHERE DATE_FORMAT(tanggal,'%Y-%m')='$bulan' 
    ORDER BY id_transaksi DESC");
if(!$q_transaksi) die("Query transaksi gagal: ".mysqli_error($koneksi));

// Total pendapatan bulan ini (tetap hitung full)
$q_total = mysqli_query($koneksi,"SELECT SUM(total_harga) AS pendapatan 
    FROM transaksi 
    WHERE DATE_FORMAT(tanggal,'%Y-%m')='$bulan'");
$total_pendapatan = mysqli_fetch_assoc($q_total)['pendapatan'] ?? 0;
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Transaksi • Elino Computer</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<style>
/* RESET & GLOBAL */
*{box-sizing:border-box;margin:0;padding:0;}
body{font-family:'Poppins', sans-serif;background:#f4f6fc;color:#333;}
a{text-decoration:none;}
button{cursor:pointer;}

/* HEADER */
.header{
    background:linear-gradient(135deg,#0d6efd,#084298);
    color:#fff;
    padding:25px 20px;
    text-align:center;
    font-size:24px;
    font-weight:600;
    letter-spacing:1px;
    box-shadow:0 2px 6px rgba(0,0,0,0.15);
}

/* SIDEBAR */
.sidebar{
    width:240px;
    background:#1e1e2f;
    color:#fff;
    position:fixed;
    top:0;
    left:0;
    height:100vh;
    padding-top:90px;
    transition: width 0.3s;
}
.sidebar h3{
    text-align:center;
    margin-bottom:25px;
    font-weight:500;
    color:#cfd2ff;
    font-size:18px;
}
.sidebar a{
    display:block;
    padding:15px 25px;
    color:#ddd;
    font-weight:500;
    transition:0.3s;
    border-left:4px solid transparent;
}
.sidebar a:hover{
    background:#343aeb;
    color:#fff;
    padding-left:30px;
    border-left:4px solid #fff;
}

/* CONTENT */
.content{
    margin-left:240px;
    padding:30px 35px;
}
.content h3{
    margin-bottom:20px;
}

/* FILTER */
.filter{
    margin-bottom:20px;
}
.filter label{
    font-weight:500;
    margin-right:10px;
}
.filter input, .filter button{
    padding:8px 12px;
    border-radius:6px;
    border:1px solid #ccc;
    font-size:14px;
}
.filter button{
    background:#0d6efd;
    color:#fff;
    border:none;
    cursor:pointer;
    transition:0.3s;
}
.filter button:hover{
    background:#084298;
}
.filter p{
    margin-top:10px;
    font-size:14px;
    font-weight:500;
    color:#555;
}

/* TABLE */
table{
    width:100%;
    border-collapse:collapse;
    background:#fff;
    border-radius:12px;
    overflow:hidden;
    box-shadow:0 10px 25px rgba(0,0,0,0.08);
}
th{
    background:#0d6efd;
    color:#fff;
    padding:14px;
    font-weight:500;
    font-size:14px;
    text-align:left;
}
td{
    padding:12px 14px;
    font-size:14px;
    border-bottom:1px solid #eee;
}
tr:hover{
    background:#f0f4ff;
}

/* BUTTON DETAIL */
.btn-detail{
    padding:6px 14px;
    background:#28a745;
    color:white;
    border:none;
    border-radius:6px;
    cursor:pointer;
    font-size:13px;
    font-weight:500;
    transition:0.3s;
}
.btn-detail:hover{
    background:#218838;
}

/* MODAL */
#modalStruk{
    display:none;
    position:fixed;
    top:0; left:0;
    width:100%;
    height:100%;
    background:rgba(0,0,0,0.5);
    justify-content:center;
    align-items:center;
}
#modalStruk > div{
    background:#fff;
    padding:25px;
    border-radius:12px;
    max-width:600px;
    width:90%;
    position:relative;
    box-shadow:0 8px 25px rgba(0,0,0,0.15);
}
#modalStruk span{
    position:absolute;
    top:10px; right:15px;
    font-size:22px;
    cursor:pointer;
}
#modalStruk button{
    margin-top:15px;
    padding:8px 14px;
    background:#28a745;
    color:white;
    border:none;
    border-radius:6px;
    cursor:pointer;
    font-weight:500;
}
#modalStruk button:hover{
    background:#218838;
}
</style>
</head>
<body>

<div class="header">
    Transaksi • Elino Computer
</div>

<div class="sidebar">
    <h3>Menu Admin</h3>
    <a href="index.php">Dashboard</a>
    <a href="users.php">Kelola User</a>
    <a href="produk.php">Kelola Produk</a>
    <a href="transaksi.php">Transaksi</a>
    <a href="laporan.php">Laporan</a>
    <a href="../logout.php">Logout</a>
</div>


<div class="content">
<h3>Seluruh Transaksi</h3>

<div class="filter">
<form method="GET" action="">
<label>Pilih Bulan:</label>
<input type="month" name="bulan" value="<?= htmlspecialchars($bulan) ?>">
<button type="submit">Filter</button>
</form>
<p>Total Pendapatan Bulan Ini: <strong>Rp <?= number_format($total_pendapatan,0,',','.') ?></strong></p>
</div>

<table>
<tr>
<th>ID</th>
<th>Kasir</th>
<th>Total</th>
<th>Bayar</th>
<th>Kembalian</th>
<th>Tanggal</th>
<th>Detail</th>
</tr>

<?php while($t=mysqli_fetch_assoc($q_transaksi)){ ?>
<tr>
<td><?= $t['id_transaksi'] ?></td>
<td><?= htmlspecialchars($t['kasir']) ?></td>
<td>Rp <?= number_format($t['total_harga'] ?? 0,0,',','.') ?></td>
<td>Rp <?= number_format($t['bayar'] ?? 0,0,',','.') ?></td>
<td>Rp <?= number_format($t['kembalian'] ?? 0,0,',','.') ?></td>
<td><?= date('d-m-Y', strtotime($t['tanggal'])) ?></td>
<td><button class="btn-detail" onclick="lihatStruk(<?= $t['id_transaksi'] ?>)">Detail</button></td>
</tr>
<?php } ?>
</table>

<!-- Modal Struk -->
<div id="modalStruk">
<div>
<span onclick="document.getElementById('modalStruk').style.display='none'">&times;</span>
<div id="kontenStruk">Loading...</div>
<button onclick="window.print()">🖨️ Cetak Struk</button>
</div>
</div>

<script>
function lihatStruk(id_transaksi){
    document.getElementById('modalStruk').style.display='flex';
    document.getElementById('kontenStruk').innerHTML = 'Loading...';
    fetch('struk_ajax.php?id_transaksi='+id_transaksi)
    .then(res=>res.text())
    .then(html=>document.getElementById('kontenStruk').innerHTML=html);
}
</script>

</div>
</body>
</html>
