<?php
session_start();
include "../koneksi.php";

if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'admin'){ 
    header("Location: ../login.php"); 
    exit; 
}

// Hapus produk jika ada request
if(isset($_GET['hapus'])){
    $id = intval($_GET['hapus']);
    $hapus = mysqli_query($koneksi,"DELETE FROM produk WHERE id_produk='$id'");
    if(!$hapus){ 
        die("Gagal menghapus: ".mysqli_error($koneksi)); 
    }
    header("Location: produk.php"); 
    exit;
}

// Pagination Logic
$limit = 10;
$page = isset($_GET['halaman']) ? (int)$_GET['halaman'] : 1;
$mulai = ($page > 1) ? ($page * $limit) - $limit : 0;

// Hitung total produk
$result_total = mysqli_query($koneksi, "SELECT COUNT(*) AS total FROM produk");
$total_data = mysqli_fetch_assoc($result_total)['total'];
$total_halaman = ceil($total_data / $limit);

// Ambil produk dengan limit
$produk = mysqli_query($koneksi,"SELECT * FROM produk ORDER BY id_produk ASC LIMIT $mulai, $limit");
if(!$produk){
    die("Query gagal: ".mysqli_error($koneksi));
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Kelola Produk • Elino Computer</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<style>
/* GLOBAL */
*{box-sizing:border-box;margin:0;padding:0;}
body{font-family:'Poppins', sans-serif;background:#f4f6fc;color:#333;}
a{text-decoration:none;}

/* HEADER */
.header{
    background:linear-gradient(135deg,#0d6efd,#084298);
    color:#fff;
    padding:25px 20px;
    text-align:center;
    font-size:24px;
    font-weight:600;
    letter-spacing:1px;
    box-shadow:0 2px 6px rgba(0,0,0,0.15);
}

/* SIDEBAR */
.sidebar{
    width:240px;
    background:#1e1e2f;
    color:#fff;
    position:fixed;
    top:0;
    left:0;
    height:100vh;
    padding-top:90px;
}
.sidebar h3{
    text-align:center;
    margin-bottom:25px;
    font-weight:500;
    color:#cfd2ff;
    font-size:18px;
}
.sidebar a{
    display:block;
    padding:15px 25px;
    color:#ddd;
    font-weight:500;
    transition:0.3s;
    border-left:4px solid transparent;
}
.sidebar a:hover{
    background:#343aeb;
    color:#fff;
    padding-left:30px;
    border-left:4px solid #fff;
}

/* CONTENT */
.content{
    margin-left:240px;
    padding:30px 35px;
}
.content h3{
    margin-bottom:20px;
}

/* BUTTON TAMBAH */
.btn-tambah{
    display:inline-block;
    background:#28a745;
    color:#fff;
    padding:10px 18px;
    border-radius:8px;
    margin-bottom:20px;
    font-weight:500;
    transition:0.3s;
}
.btn-tambah:hover{
    background:#218838;
}

/* TABLE */
table{
    width:100%;
    border-collapse:collapse;
    background:#fff;
    border-radius:12px;
    overflow:hidden;
    box-shadow:0 10px 25px rgba(0,0,0,0.08);
}
th{
    background:#0d6efd;
    color:#fff;
    padding:14px;
    font-weight:500;
    font-size:14px;
    text-align:left;
}
td{
    padding:12px 14px;
    font-size:14px;
    border-bottom:1px solid #eee;
}
tr:hover{
    background:#f0f4ff;
}

/* AKSI BUTTON */
.aksi a{
    display:inline-block;
    padding:6px 14px;
    color:white;
    border-radius:6px;
    text-decoration:none;
    margin:0 4px;
    font-size:13px;
    font-weight:500;
    transition:0.3s;
}
.edit{background:#ffc107;color:#212529;}
.edit:hover{background:#e0a800;color:#212529;}
.hapus{background:#dc3545;}
.hapus:hover{background:#b02a37;}

/* PAGINATION */
.pagination {
    display: flex;
    justify-content: center;
    margin-top: 20px;
}
.pagination a {
    color: #333;
    padding: 8px 16px;
    text-decoration: none;
    border: 1px solid #ddd;
    margin: 0 4px;
    border-radius: 5px;
    transition: background-color .3s;
}
.pagination a.active {
    background-color: #0d6efd;
    color: white;
    border: 1px solid #0d6efd;
}
.pagination a:hover:not(.active) {background-color: #ddd;}
</style>
</head>
<body>

<div class="header">
    <h2>Produk • Elino Computer</h2>
</div>

<div class="sidebar">
    <h3>Menu Admin</h3>
    <a href="index.php">Dashboard</a>
    <a href="users.php">Kelola User</a>
    <a href="produk.php">Kelola Produk</a>
    <a href="transaksi.php">Transaksi</a>
    <a href="laporan.php">Laporan</a>
    <a href="../logout.php">Logout</a>
</div>


<div class="content">
    <h3>Kelola Produk</h3>

    <a href="produk_tambah.php" class="btn-tambah">+ Tambah Produk</a>

    <table>
        <tr>
            <th>ID</th>
            <th>Nama Produk</th>
            <th>Harga</th>
            <th>Stok</th>
            <th>Aksi</th>
        </tr>
        <?php while($p = mysqli_fetch_assoc($produk)) { ?>
        <tr>
            <td><?= $p['id_produk']; ?></td>
            <td><?= htmlspecialchars($p['nama_produk']); ?></td>
            <td>Rp <?= number_format($p['harga'],0,',','.'); ?></td>
            <td><?= $p['stok']; ?></td>
            <td class="aksi">
                <a href="produk_edit.php?id=<?= $p['id_produk']; ?>" class="edit">Edit</a>
                <a href="produk.php?hapus=<?= $p['id_produk']; ?>" 
                   class="hapus"
                   onclick="return confirm('Yakin hapus produk ini?')">Hapus</a>
            </td>
        </tr>
        <?php } ?>
    </table>

    <div class="pagination">
        <?php for($i=1; $i<=$total_halaman; $i++): ?>
            <a href="?halaman=<?= $i ?>" class="<?= ($i == $page) ? 'active' : '' ?>"><?= $i ?></a>
        <?php endfor; ?>
    </div>
</div>

</body>
</html>
