<?php
session_start();
include "../koneksi.php";

if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'admin'){
    header("Location: ../login.php");
    exit;
}

$tgl_mulai = $_GET['tgl_mulai'] ?? date('Y-m-01');
$tgl_selesai = $_GET['tgl_selesai'] ?? date('Y-m-d');

$query = "SELECT * FROM transaksi WHERE tanggal BETWEEN '$tgl_mulai' AND '$tgl_selesai' ORDER BY id_transaksi DESC";
$sql = mysqli_query($koneksi, $query);

// Hitung total pendapatan dalam periode tersebut
$q_total = mysqli_query($koneksi, "SELECT SUM(total_harga) as grand_total FROM transaksi WHERE tanggal BETWEEN '$tgl_mulai' AND '$tgl_selesai'");
$total_pendapatan = mysqli_fetch_assoc($q_total)['grand_total'] ?? 0;
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Laporan Transaksi • Elino Computer</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
/* RESET & GLOBAL */
* { box-sizing: border-box; margin: 0; padding: 0; }
body { font-family: 'Poppins', sans-serif; background: #f4f6fc; color: #333; }
a { text-decoration: none; }
button { cursor: pointer; }

/* HEADER */
.header {
    background: linear-gradient(135deg,#0d6efd,#084298);
    color: #fff;
    padding: 25px 20px;
    text-align: center;
    font-size: 24px;
    font-weight: 600;
    letter-spacing: 1px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.15);
}

/* SIDEBAR */
.sidebar {
    width: 240px;
    background: #1e1e2f;
    color: #fff;
    position: fixed;
    top: 0;
    left: 0;
    height: 100vh;
    padding-top: 90px;
}
.sidebar h3 {
    text-align: center;
    margin-bottom: 25px;
    font-weight: 500;
    color: #cfd2ff;
    font-size: 18px;
}
.sidebar a {
    display: block;
    padding: 15px 25px;
    color: #ddd;
    font-weight: 500;
    transition: 0.3s;
    border-left: 4px solid transparent;
}
.sidebar a:hover {
    background: #343aeb;
    color: #fff;
    padding-left: 30px;
    border-left: 4px solid #fff;
}

/* CONTENT */
.content {
    margin-left: 240px;
    padding: 30px 35px;
}
.content h3 { margin-bottom: 20px; }

/* FILTER FORM */
.filter-box {
    background: #fff;
    padding: 20px;
    border-radius: 12px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    margin-bottom: 30px;
    display: flex;
    align-items: flex-end;
    gap: 15px;
    flex-wrap: wrap;
}
.filter-box div { flex: 1; min-width: 200px; }
.filter-box label { display: block; font-size: 13px; margin-bottom: 5px; color: #666; }
.filter-box input { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 8px; font-family: inherit; }
.btn-filter { background: #0d6efd; color: #fff; border: none; padding: 10px 20px; border-radius: 8px; font-weight: 500; height: 42px; transition: 0.3s; }
.btn-filter:hover { background: #0b5ed7; }
.btn-export { background: #198754; color: #fff; border: none; padding: 10px 20px; border-radius: 8px; font-weight: 500; height: 42px; transition: 0.3s; display: inline-flex; align-items: center; gap: 8px; }
.btn-export:hover { background: #157347; }

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    background: #fff;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 10px 25px rgba(0,0,0,0.08);
}
th {
    background: #0d6efd;
    color: #fff;
    padding: 14px;
    font-weight: 500;
    font-size: 14px;
    text-align: left;
}
td {
    padding: 12px 14px;
    font-size: 14px;
    border-bottom: 1px solid #eee;
}
tr:hover { background: #f0f4ff; }
.total-row { background: #f8f9fa; font-weight: 600; font-size: 16px; }

/* PRINT STYLES */
@media print {
    .sidebar, .filter-box, .header, .btn-filter, .btn-export { display: none; }
    .content { margin-left: 0; padding: 0; }
    table { box-shadow: none; border: 1px solid #ddd; }
}
</style>
</head>
<body>

<div class="header">
    <h2>Laporan • Elino Computer</h2>
</div>

<div class="sidebar">
    <h3>Menu Admin</h3>
    <a href="index.php">Dashboard</a>
    <a href="users.php">Kelola User</a>
    <a href="produk.php">Kelola Produk</a>
    <a href="transaksi.php">Transaksi</a>
    <a href="laporan.php">Laporan</a>
    <a href="../logout.php">Logout</a>
</div>

<div class="content">
    <h3>Laporan Transaksi</h3>

    <form method="GET" class="filter-box">
        <div>
            <label>Tanggal Mulai</label>
            <input type="date" name="tgl_mulai" value="<?= $tgl_mulai ?>">
        </div>
        <div>
            <label>Tanggal Selesai</label>
            <input type="date" name="tgl_selesai" value="<?= $tgl_selesai ?>">
        </div>
        <button type="submit" class="btn-filter">Filter</button>
        <button type="button" onclick="window.print()" class="btn-export"><i class="fa fa-print"></i> Cetak PDF</button>
    </form>


    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>ID Transaksi</th>
                <th>Tanggal</th>
                <th>Kasir</th>
                <th>Total Harga</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $no = 1;
            while($d = mysqli_fetch_assoc($sql)){ 
            ?>
            <tr>
                <td><?= $no++ ?></td>
                <td>#<?= $d['id_transaksi'] ?></td>
                <td><?= date('d/m/Y', strtotime($d['tanggal'])) ?></td>
                <td><?= htmlspecialchars($d['kasir']) ?></td>
                <td>Rp <?= number_format($d['total_harga'],0,',','.') ?></td>
            </tr>
            <?php } ?>
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="4" style="text-align: right;">TOTAL PENDAPATAN :</td>
                <td>Rp <?= number_format($total_pendapatan,0,',','.') ?></td>
            </tr>
        </tfoot>
    </table>
</div>

</body>
</html>
