<?php
session_start();
include "../koneksi.php";

if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'admin'){
    header("Location: ../login.php");
    exit;
}

// Total user
$q_user = mysqli_query($koneksi,"SELECT COUNT(*) AS total FROM users");
$total_user = mysqli_fetch_assoc($q_user)['total'] ?? 0;

// Total produk
$q_produk = mysqli_query($koneksi,"SELECT COUNT(*) AS total FROM produk");
$total_produk = mysqli_fetch_assoc($q_produk)['total'] ?? 0;

// Transaksi bulan ini
$bulan_ini = date('Y-m');
$q_transaksi = mysqli_query($koneksi,"SELECT COUNT(*) AS total, SUM(total_harga) AS pendapatan 
    FROM transaksi 
    WHERE DATE_FORMAT(tanggal,'%Y-%m')='$bulan_ini'");
$row = mysqli_fetch_assoc($q_transaksi);
$total_transaksi = $row['total'] ?? 0;
$total_pendapatan = $row['pendapatan'] ?? 0;

// 5 transaksi terakhir dari semua kasir
$q_histori = mysqli_query($koneksi,"SELECT id_transaksi, kasir, total_harga, bayar, kembalian, tanggal 
    FROM transaksi 
    ORDER BY id_transaksi DESC 
    LIMIT 5");
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Dashboard Admin • Elino Computer</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<style>
/* RESET & GLOBAL */
* { box-sizing: border-box; margin: 0; padding: 0; }
body { font-family: 'Poppins', sans-serif; background: #f4f6fc; color: #333; }
a { text-decoration: none; }
button { cursor: pointer; }

/* HEADER */
.header {
    background: linear-gradient(135deg,#0d6efd,#084298);
    color: #fff;
    padding: 25px 20px;
    text-align: center;
    font-size: 24px;
    font-weight: 600;
    letter-spacing: 1px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.15);
}

/* SIDEBAR */
.sidebar {
    width: 240px;
    background: #1e1e2f;
    color: #fff;
    position: fixed;
    top: 0;
    left: 0;
    height: 100vh;
    padding-top: 90px;
    transition: width 0.3s;
}
.sidebar h3 {
    text-align: center;
    margin-bottom: 25px;
    font-weight: 500;
    color: #cfd2ff;
    font-size: 18px;
}
.sidebar a {
    display: block;
    padding: 15px 25px;
    color: #ddd;
    font-weight: 500;
    transition: 0.3s;
    border-left: 4px solid transparent;
}
.sidebar a:hover {
    background: #343aeb;
    color: #fff;
    padding-left: 30px;
    border-left: 4px solid #fff;
}

/* CONTENT */
.content {
    margin-left: 240px;
    padding: 30px 35px;
}
.content h3 { margin-bottom: 10px; }
.content p { margin-bottom: 25px; color: #555; font-size: 15px; }

/* CARDS */
.cards {
    display: grid;
    grid-template-columns: repeat(auto-fit,minmax(220px,1fr));
    gap: 22px;
    margin: 20px 0 35px 0;
}
.card {
    background: #fff;
    padding: 28px;
    border-radius: 12px;
    box-shadow: 0 10px 25px rgba(0,0,0,0.08);
    transition: transform 0.3s, box-shadow 0.3s;
    position: relative;
}
.card:hover {
    transform: translateY(-6px);
    box-shadow: 0 12px 28px rgba(0,0,0,0.12);
}
.card h4 { font-size: 15px; color: #666; font-weight: 500; }
.card p { font-size: 28px; font-weight: 600; color: #0d6efd; margin-top: 12px; }

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    background: #fff;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 10px 25px rgba(0,0,0,0.08);
    margin-top: 20px;
}
th {
    background: #0d6efd;
    color: #fff;
    padding: 14px;
    font-weight: 500;
    font-size: 14px;
    text-align: left;
}
td {
    padding: 12px 14px;
    font-size: 14px;
    border-bottom: 1px solid #eee;
}
tr:hover { background: #f0f4ff; }

/* BUTTON DETAIL */
.btn-detail {
    padding: 7px 14px;
    background: #198754;
    color: white;
    border: none;
    border-radius: 6px;
    font-size: 13px;
    font-weight: 500;
    transition: 0.3s;
}
.btn-detail:hover { background: #157347; }

/* MODAL */
#modalStruk {
    display: none;
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.6);
    justify-content: center;
    align-items: center;
    z-index: 999;
}
#modalStruk > div {
    background: #fff;
    padding: 25px;
    border-radius: 10px;
    max-width: 650px;
    width: 90%;
    position: relative;
    animation: zoom 0.3s ease;
}
@keyframes zoom {
    from { transform: scale(0.8); opacity: 0; }
    to { transform: scale(1); opacity: 1; }
}
#modalStruk span.close {
    position: absolute;
    top: 12px;
    right: 18px;
    font-size: 22px;
    cursor: pointer;
    font-weight: 600;
    color: #333;
}

/* PRINT BUTTON */
#printBtn {
    margin-top: 15px;
    padding: 7px 15px;
    background: #28a745;
    color: white;
    border: none;
    border-radius: 6px;
    font-weight: 500;
    transition: 0.3s;
}
#printBtn:hover { background: #218838; }
</style>
</head>
<body>

<div class="header">
    <h2>Admin • Elino Computer</h2>
</div>

<div class="sidebar">
    <h3>Menu Admin</h3>
    <a href="index.php">Dashboard</a>
    <a href="users.php">Kelola User</a>
    <a href="produk.php">Kelola Produk</a>
    <a href="transaksi.php">Transaksi</a>
    <a href="laporan.php">Laporan</a>
    <a href="../logout.php">Logout</a>
</div>


<div class="content">
    <h3>Selamat datang, <?= htmlspecialchars($_SESSION['username']); ?>!</h3>
    <p>Anda login sebagai <strong><?= htmlspecialchars($_SESSION['role']); ?></strong></p>

    <h4>Info Singkat:</h4>
    <div class="cards">
        <div class="card"><h4>Total User</h4><p><?= $total_user ?></p></div>
        <div class="card"><h4>Total Produk</h4><p><?= $total_produk ?></p></div>
        <div class="card"><h4>Transaksi Bulan Ini</h4><p><?= $total_transaksi ?></p></div>
        <div class="card"><h4>Total Pendapatan Bulan Ini</h4><p>Rp <?= number_format($total_pendapatan,0,',','.') ?></p></div>
        <a href="laporan.php" class="card" style="display: block; background: #e7f1ff; border: 2px dashed #0d6efd;">
            <h4 style="color: #0d6efd;">Cetak Laporan</h4>
            <p style="font-size: 14px; color: #555; margin-top: 5px;">Klik untuk filter & download laporan detail</p>
        </a>
    </div>


    <h4>Transaksi Terbaru</h4>
    <table>
        <tr>
            <th>ID</th><th>Kasir</th><th>Total</th><th>Bayar</th><th>Kembalian</th><th>Tanggal</th><th>Detail</th>
        </tr>
        <?php while($t=mysqli_fetch_assoc($q_histori)){ ?>
        <tr>
            <td><?= $t['id_transaksi'] ?></td>
            <td><?= htmlspecialchars($t['kasir']) ?></td>
            <td>Rp <?= number_format($t['total_harga'] ?? 0,0,',','.') ?></td>
            <td>Rp <?= number_format($t['bayar'] ?? 0,0,',','.') ?></td>
            <td>Rp <?= number_format($t['kembalian'] ?? 0,0,',','.') ?></td>
            <td><?= date('d-m-Y', strtotime($t['tanggal'])) ?></td>
            <td><button class="btn-detail" onclick="lihatStruk(<?= $t['id_transaksi'] ?>)">Detail</button></td>
        </tr>
        <?php } ?>
    </table>

    <!-- Modal Struk -->
    <div id="modalStruk">
        <div>
            <span class="close" onclick="document.getElementById('modalStruk').style.display='none'">&times;</span>
            <div id="kontenStruk">Loading...</div>
            <button id="printBtn" onclick="window.print()">🖨️ Cetak Struk</button>
        </div>
    </div>
</div>

<script>
function lihatStruk(id_transaksi){
    document.getElementById('modalStruk').style.display='flex';
    document.getElementById('kontenStruk').innerHTML = 'Loading...';
    fetch('struk_ajax.php?id_transaksi='+id_transaksi)
    .then(res => res.text())
    .then(html => document.getElementById('kontenStruk').innerHTML = html);
}
</script>

</body>
</html>
