<?php
session_start();
include "../koneksi.php";

// Cek login admin
if(!isset($_SESSION['id_user']) || $_SESSION['role'] != 'admin'){
    header("Location: ../login.php");
    exit;
}

// Ambil ID user
$id = intval($_GET['id'] ?? 0);
if($id <= 0){
    header("Location: users.php");
    exit;
}

// Ambil data user dari database
$q = mysqli_query($koneksi, "SELECT * FROM users WHERE id_user=$id");
$user = mysqli_fetch_assoc($q);
if(!$user){
    echo "User tidak ditemukan!";
    exit;
}

// Proses update
if(isset($_POST['submit'])){
    $nama = mysqli_real_escape_string($koneksi, $_POST['nama']);
    $username = mysqli_real_escape_string($koneksi, $_POST['username']);
    $email = mysqli_real_escape_string($koneksi, $_POST['email']);

    // Update password hanya jika diisi
    if(!empty($_POST['password'])){
        $password_plain = $_POST['password'];
        $password_hash = password_hash($password_plain, PASSWORD_DEFAULT);
        mysqli_query($koneksi, "UPDATE users SET 
            nama='$nama', 
            username='$username', 
            email='$email',
            password='$password_hash', 
            password_text='$password_plain' 
            WHERE id_user=$id");
    } else {
        mysqli_query($koneksi, "UPDATE users SET 
            nama='$nama', 
            username='$username', 
            email='$email' 
            WHERE id_user=$id");
    }

    header("Location: users.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Edit User - Admin</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<style>
/* GLOBAL */
body {
    font-family: 'Poppins', sans-serif;
    background: #f0f2f5;
    margin: 0;
    padding: 0;
}
a{text-decoration:none;}

/* HEADER */
.header{
    background:linear-gradient(135deg,#0d6efd,#084298);
    color:#fff;
    padding:25px 20px;
    text-align:center;
    font-size:24px;
    font-weight:600;
    letter-spacing:1px;
    box-shadow:0 2px 6px rgba(0,0,0,0.15);
}

/* SIDEBAR */
.sidebar{
    width:240px;
    background:#1e1e2f;
    color:#fff;
    position:fixed;
    top:0;
    left:0;
    height:100vh;
    padding-top:90px;
    transition: width 0.3s;
}
.sidebar h3{
    text-align:center;
    margin-bottom:25px;
    font-weight:500;
    color:#cfd2ff;
    font-size:18px;
}
.sidebar a{
    display:block;
    padding:15px 25px;
    color:#ddd;
    font-weight:500;
    transition:0.3s;
    border-left:4px solid transparent;
    text-decoration: none; /* hilangkan underline */
}
.sidebar a:hover{
    background:#343aeb;
    color:#fff;
    padding-left:30px;
    border-left:4px solid #fff;
    text-decoration: none; /* tetap tanpa underline */
}

/* CONTENT */
.content {
    margin-left:240px;
    padding:30px 35px;
}
.content h2 {
    text-align:center;
    color:#1a73e8;
    margin-bottom:30px;
}

/* FORM */
form label {
    display: block;
    margin-top: 15px;
    font-weight: 600;
    color: #333;
}
form input, form select {
    width: 100%;
    padding: 10px;
    margin-top: 5px;
    border-radius: 5px;
    border: 1px solid #ccc;
    font-size: 14px;
}
form input:focus, form select:focus {
    outline: none;
    border-color: #1a73e8;
    box-shadow: 0 0 5px rgba(26, 115, 232, 0.3);
}
small {
    color: #666;
    font-weight: normal;
}
button {
    width: 100%;
    margin-top: 25px;
    padding: 12px;
    background: #1a73e8;
    color: white;
    border: none;
    border-radius: 8px;
    font-size: 16px;
    cursor: pointer;
    transition: 0.3s;
}
button:hover {
    background: #155ab6;
}
.back {
    display: inline-block;
    margin-top: 20px;
    text-decoration: none;
    color: #1a73e8;
    font-weight: bold;
}
.back:hover {
    text-decoration: underline;
}
.container {
    max-width: 500px;
    margin: 50px auto;
    background: #fff;
    padding: 30px 40px;
    border-radius: 12px;
    box-shadow: 0 8px 20px rgba(0,0,0,0.1);
}
</style>
</head>
<body>

<div class="header">Edit User • Elino Computer</div>

<div class="sidebar">
    <h3>Menu Admin</h3>
    <a href="index.php">Dashboard</a>
    <a href="users.php">Kelola User</a>
    <a href="produk.php">Kelola Produk</a>
    <a href="transaksi.php">Transaksi</a>
    <a href="../logout.php">Logout</a>
</div>

<div class="content">
<div class="container">
<h2>Edit User</h2>

<form method="post">
    <label>Nama Lengkap</label>
    <input type="text" name="nama" value="<?= htmlspecialchars($user['nama']); ?>" required>

    <label>Username Login</label>
    <input type="text" name="username" value="<?= htmlspecialchars($user['username']); ?>" required>

    <label>Email Perusahaan</label>
    <input type="email" name="email" value="<?= htmlspecialchars($user['email'] ?? ''); ?>" placeholder="admin@perusahaan.com">

    <label>Password <small>(kosongkan jika tidak ingin mengubah)</small></label>
    <input type="password" name="password">

    <button type="submit" name="submit">Simpan Perubahan</button>
</form>

<a href="users.php" class="back">← Kembali ke Daftar User</a>
</div>
</div>

</body>
</html>
